package ru.yandex.solomon.alert.cluster.broker.notification.search;

import java.util.Comparator;

import ru.yandex.solomon.alert.notification.domain.Notification;
import ru.yandex.solomon.alert.protobuf.EOrderDirection;
import ru.yandex.solomon.alert.protobuf.TListNotificationsRequest;

import static java.util.Comparator.comparing;

/**
 * @author Vladimir Gordiychuk
 */
final class NotificationSorts {
    private NotificationSorts() {
    }

    public static Comparator<Notification> orderByName(EOrderDirection direction) {
        return order(comparing(Notification::getName), direction);
    }

    public static Comparator<Notification> orderByType(EOrderDirection direction) {
        return order(comparing(Notification::getType), direction);
    }

    private static <T> Comparator<T> order(Comparator<T> comparator, EOrderDirection direction) {
        if (direction == EOrderDirection.DESC) {
            return comparator.reversed();
        }

        return comparator;
    }

    public static Comparator<Notification> orderBy(TListNotificationsRequest request) {
        switch (request.getOrderByCase()) {
            case ORDERBY_NOT_SET:
                return orderByName(EOrderDirection.ASC);
            case ORDERBYNAME:
                return orderByName(request.getOrderByName());
            case ORDERBYTYPE:
                return orderByName(EOrderDirection.ASC)
                        .thenComparing(orderByType(request.getOrderByType()));
            default:
                throw new UnsupportedOperationException("Not supported ordering: " + request);
        }
    }
}
