package ru.yandex.solomon.alert.cluster.broker.quota;

import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.commons.lang3.mutable.MutableLong;

import ru.yandex.solomon.quotas.watcher.QuotaWatcher;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class AlertingProjectQuota {
    private final String projectId;
    private final QuotaWatcher quotaWatcher;
    private final MutableLong alertCount; // synchronized access is needed

    private final static long ALERT_COUNT_UNLIMITED = 1_000_000_000;
    final static String ALERT_COUNT_INDICATOR = "alerts.count";

    public AlertingProjectQuota(QuotaWatcher quotaWatcher, String projectId) {
        this.projectId = projectId;
        this.quotaWatcher = quotaWatcher;
        this.alertCount = new MutableLong(0);
    }

    public void setAlertCount(int count) {
        // This is done in ALERT_FETCH state, so no race is possible
        alertCount.setValue(count);
    }

    public long getAlertCountValue() {
        return alertCount.longValue();
    }

    public long getAlertCountLimit() {
        return quotaWatcher.getLimit("project", projectId, ALERT_COUNT_INDICATOR).orElse(ALERT_COUNT_UNLIMITED);
    }

    public boolean tryIncAlertCount() {
        final long limit = getAlertCountLimit();

        // TODO: can this be done via AtomicLong?
        synchronized (alertCount) {
            if (alertCount.longValue() < limit) {
                alertCount.increment();
                return true;
            } else {
                return false;
            }
        }
    }

    public void decAlertCount() {
        synchronized (alertCount) {
            alertCount.decrement();
        }
    }
}
