package ru.yandex.solomon.alert.cluster.broker.quota;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.MetricConsumer;
import ru.yandex.monlib.metrics.MetricSupplier;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.primitives.GaugeInt64;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class QuotaMetrics implements MetricSupplier {
    private final MetricRegistry registry;

    private static final String QUOTA_VALUE = "quota.value";
    private static final String QUOTA_LIMIT = "quota.limit";
    private static final String INDICATOR = "indicator";

    private final GaugeInt64 alertCountValue;
    private final GaugeInt64 alertCountLimit;

    public QuotaMetrics(MetricRegistry registry) {
        this.registry = registry;

        alertCountValue = registry.gaugeInt64(QUOTA_VALUE, Labels.of(INDICATOR, AlertingProjectQuota.ALERT_COUNT_INDICATOR));
        alertCountLimit = registry.gaugeInt64(QUOTA_LIMIT, Labels.of(INDICATOR, AlertingProjectQuota.ALERT_COUNT_INDICATOR));
    }

    public void update(AlertingProjectQuota quota) {
        alertCountValue.set(quota.getAlertCountValue());
        alertCountLimit.set(quota.getAlertCountLimit());
    }

    @Override
    public int estimateCount() {
        return registry.estimateCount();
    }

    @Override
    public void append(long tsMillis, Labels commonLabels, MetricConsumer consumer) {
        registry.append(tsMillis, commonLabels, consumer);
    }
}
