package ru.yandex.solomon.alert.cluster.discovery;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

import ru.yandex.cluster.discovery.ClusterDiscovery;
import ru.yandex.grpc.utils.GrpcTransport;

/**
 * @author Vladimir Gordiychuk
 */
public class AlertingClusterDiscovery implements ClusterDiscovery<GrpcTransport> {
    private final ClusterDiscovery<AlertingTransports> discovery;
    private final Function<AlertingTransports, GrpcTransport> fn;

    public AlertingClusterDiscovery(ClusterDiscovery<AlertingTransports> discovery, Function<AlertingTransports, GrpcTransport> fn) {
        this.discovery = discovery;
        this.fn = fn;
    }

    public static ClusterDiscovery<GrpcTransport> internal(ClusterDiscovery<AlertingTransports> discovery) {
        return new AlertingClusterDiscovery(discovery, transports -> transports.internalApi);
    }

    @Override
    public boolean hasNode(String node) {
        return discovery.hasNode(node);
    }

    @Override
    public Set<String> getNodes() {
        return discovery.getNodes();
    }

    @Override
    public GrpcTransport getTransport() {
        return fn.apply(discovery.getTransport());
    }

    @Override
    public GrpcTransport getTransportByNode(String node) {
        return fn.apply(discovery.getTransportByNode(node));
    }

    @Override
    public CompletableFuture<Void> forceUpdate() {
        return discovery.forceUpdate();
    }

    @Override
    public void callbackOnChange(Runnable oneShotCallback) {
        discovery.callbackOnChange(oneShotCallback);
    }

    @Override
    public void close() {
    }
}
