package ru.yandex.solomon.alert.cluster.health;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.alert.cluster.AlertingHeartbeatProcess;
import ru.yandex.solomon.staffOnly.manager.ok.OkProvider;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class ClusterMembershipChecker implements OkProvider {
    // todo local address
    private final AlertingHeartbeatProcess heartbeatProcess;

    public ClusterMembershipChecker(AlertingHeartbeatProcess heartbeatProcess, MetricRegistry registry) {
        this.heartbeatProcess = heartbeatProcess;
        registry.lazyGaugeInt64("health.cluster.membership", () -> {
            if (heartbeatProcess.isConnected()) {
                return 1;
            } else {
                return 0;
            }
        });
    }

    @Nonnull
    public Status status() {
        boolean connected = heartbeatProcess.isConnected();
        return new Status(ClusterMembershipChecker.class.getSimpleName(), connected, "");
    }

    @Nonnull
    @Override
    public Status[] statuses() {
        return new Status[]{status()};
    }
}
