package ru.yandex.solomon.alert.cluster.health;

import java.util.stream.Stream;

import javax.annotation.Nonnull;

import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.alert.cluster.balancer.AlertingLocalShards;
import ru.yandex.solomon.staffOnly.manager.ok.OkProvider;

/**
 * @author Vladimir Gordiychuk
 */
public class ProjectReadinessChecker implements OkProvider {
    private final AlertingLocalShards localShards;

    public ProjectReadinessChecker(
            AlertingLocalShards localShards,
            MetricRegistry registry)
    {
        this.localShards = localShards;
        registry.lazyGaugeInt64("health.projects.readiness", () -> {
            if (assignedProjects().allMatch(localShards::isReady)) {
                return 1;
            } else {
                return 0;
            }
        });
    }

    @Nonnull
    @Override
    public Status[] statuses() {
        return assignedProjects()
                .sorted()
                .map(this::check)
                .toArray(Status[]::new);
    }

    private Status check(String projectId) {
        boolean ready = localShards.isReady(projectId);
        String message = ready
                ? "project " + projectId + " ready"
                : "project " + projectId + " not ready";
        return new Status(ProjectReadinessChecker.class.getSimpleName(), ready, message);
    }

    private Stream<String> assignedProjects() {
        return localShards.assignedShards().stream();
    }
}
