package ru.yandex.solomon.alert.cluster.project;

import java.util.Collections;
import java.util.Map;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.base.MoreObjects;

import ru.yandex.solomon.balancer.AssignmentSeqNo;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class AssignmentSnapshot implements Comparable<AssignmentSnapshot> {
    public static final AssignmentSnapshot EMPTY = new AssignmentSnapshot(Collections.emptyMap(), AssignmentSeqNo.EMPTY);

    private final AssignmentSeqNo seqNo;
    private final Map<String, ProjectAssignment> assignmentByProjectId;

    public AssignmentSnapshot(Map<String, ProjectAssignment> assignmentByProjectId, AssignmentSeqNo seqNo) {
        this.seqNo = seqNo;
        this.assignmentByProjectId = assignmentByProjectId;
    }

    public Map<String, ProjectAssignment> getAssignmentByProjectId() {
        return assignmentByProjectId;
    }

    @Nullable
    public ProjectAssignment getAssignment(String projectId) {
        return assignmentByProjectId.get(projectId);
    }

    public long getProjectSeqNo() {
        return getAssignmentSeqNo().getAssignSeqNo();
    }

    public AssignmentSeqNo getAssignmentSeqNo() {
        return seqNo;
    }

    public AssignmentSnapshot updateLeaderSeqNo(long leaderSeqNo) {
        return new AssignmentSnapshot(assignmentByProjectId, new AssignmentSeqNo(leaderSeqNo, seqNo.getAssignSeqNo()));
    }

    @Override
    public int compareTo(AssignmentSnapshot right) {
        return seqNo.compareTo(right.seqNo);
    }

    public int size() {
        return assignmentByProjectId.size();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AssignmentSnapshot snapshot = (AssignmentSnapshot) o;

        if (!seqNo.equals(snapshot.seqNo)) return false;
        return assignmentByProjectId.equals(snapshot.assignmentByProjectId);
    }

    @Override
    public int hashCode() {
        int result = seqNo.hashCode();
        result = 31 * result + assignmentByProjectId.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("seqNo", seqNo)
                .add("assignments", assignmentByProjectId.values())
                .toString();
    }
}
