package ru.yandex.solomon.alert.cluster.project;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.base.MoreObjects;

import ru.yandex.solomon.balancer.AssignmentSeqNo;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class ProjectAssignment implements Comparable<ProjectAssignment> {
    private final String projectId;
    private final String address;
    private final AssignmentSeqNo seqNo;

    public ProjectAssignment(String projectId, String address, AssignmentSeqNo seqNo) {
        this.projectId = projectId;
        this.address = address;
        this.seqNo = seqNo;
    }

    public String getProjectId() {
        return projectId;
    }

    public String getAddress() {
        return address;
    }

    public AssignmentSeqNo getSeqNo() {
        return seqNo;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ProjectAssignment that = (ProjectAssignment) o;

        if (!projectId.equals(that.projectId)) return false;
        if (!address.equals(that.address)) return false;
        return seqNo.equals(that.seqNo);
    }

    @Override
    public int hashCode() {
        int result = projectId.hashCode();
        result = 31 * result + address.hashCode();
        result = 31 * result + seqNo.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("projectId", projectId)
                .add("address", address)
                .add("seqNo", seqNo)
                .toString();
    }

    @Override
    public int compareTo(ProjectAssignment right) {
        return seqNo.compareTo(right.seqNo);
    }
}
