package ru.yandex.solomon.alert.cluster.server.grpc;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import com.google.common.collect.Sets;

import ru.yandex.solomon.balancer.AssignmentSeqNo;

/**
 * @author Vladimir Gordiychuk
 */
public class AssignmentTracker {
    private final ConcurrentMap<String, AssignmentSeqNo> latestSeenAssignmentSeqNo = new ConcurrentHashMap<>();
    private final Set<ObsoleteListener> listeners = Sets.newConcurrentHashSet();

    public boolean isValid(String projectId, AssignmentSeqNo seqNo) {
        latestSeenAssignmentSeqNo.putIfAbsent(projectId, seqNo);
        AssignmentSeqNo prev;
        do {
            prev = latestSeenAssignmentSeqNo.get(projectId);
            int compare = prev.compareTo(seqNo);
            if (compare == 0) {
                return true;
            } else if (compare > 0) {
                return false;
            }
        } while (!latestSeenAssignmentSeqNo.replace(projectId, prev, seqNo));
        obsolete(projectId, prev);
        return true;
    }

    private void obsolete(String projectId, AssignmentSeqNo seqNo) {
        for (var listener : listeners) {
            listener.obsolete(projectId, seqNo);
        }
    }

    public void subscribe(ObsoleteListener listener) {
        listeners.add(listener);
    }

    public void unsubscribe(ObsoleteListener listener) {
        listeners.remove(listener);
    }

    public interface ObsoleteListener {
        void obsolete(String projectId, AssignmentSeqNo seqNo);
    }
}
