package ru.yandex.solomon.alert.cluster.server.grpc.evaluation;

import java.util.concurrent.atomic.AtomicInteger;

import ru.yandex.solomon.alert.protobuf.EvaluationStreamServerMessage.Evaluation;
import ru.yandex.solomon.alert.util.RateLimit;
import ru.yandex.solomon.alert.util.RateLimiters;

/**
 * @author Vladimir Gordiychuk
 */
public class ClientEvaluationBreakerImpl implements ClientEvaluationBreaker {
    private volatile boolean active = true;
    private final AtomicInteger waitToUnassign = new AtomicInteger();
    private final RateLimit interruptLimiter = RateLimiters.create(10000);

    @Override
    public boolean continueEvaluation(Evaluation evaluation) {
        if (isInterruptByState()) {
            return false;
        }

        if (isInterruptByRequest()) {
            return false;
        }

        return true;
    }

    private boolean isInterruptByState() {
        if (active) {
            return false;
        }

        return interruptLimiter.attempt();
    }

    private boolean isInterruptByRequest() {
        int count = waitToUnassign.get();
        if (count == 0) {
            return false;
        }

        if (!interruptLimiter.attempt()) {
            return false;
        }

        while (!waitToUnassign.compareAndSet(count, count - 1)) {
            count = waitToUnassign.get();
            if (count == 0) {
                return false;
            }
        }

        return true;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void unassign(int count) {
        waitToUnassign.set(count);
    }

    public void cancelUnassign() {
        waitToUnassign.set(0);
    }
}
