package ru.yandex.solomon.alert.cluster.server.grpc.evaluation;

import io.grpc.stub.StreamObserver;

import ru.yandex.solomon.alert.protobuf.EvaluationStreamClientMessage;
import ru.yandex.solomon.alert.protobuf.EvaluationStreamClientMessage.AssignEvaluation;
import ru.yandex.solomon.alert.protobuf.EvaluationStreamClientMessage.UnassignEvaluation;

/**
 * @author Vladimir Gordiychuk
 */
public class EvaluationStreamClientMessageWriter extends BatchWriter<EvaluationStreamClientMessage> {
    private final EvaluationStreamClientMessage.Builder builder = EvaluationStreamClientMessage.newBuilder();

    public EvaluationStreamClientMessageWriter(StreamObserver<EvaluationStreamClientMessage> output, int maxBatchSize) {
        super(output, maxBatchSize);
    }

    public EvaluationStreamClientMessageWriter(StreamObserver<EvaluationStreamClientMessage> output) {
        super(output, MAX_BATCH_SIZE_IN_BYTES);
    }

    public void onNext(AssignEvaluation assign) {
        builder.addAssignEvaluations(assign);
        add(assign.getSerializedSize());
    }

    public void onNext(UnassignEvaluation unassign) {
        builder.addUnassignEvaluations(unassign);
        add(unassign.getSerializedSize());
    }

    @Override
    protected EvaluationStreamClientMessage build() {
        try {
            return builder.build();
        } finally {
            builder.clear();
        }
    }
}
