package ru.yandex.solomon.alert.cluster.server.grpc.evaluation;

import java.util.List;

import io.grpc.stub.StreamObserver;

import ru.yandex.solomon.alert.protobuf.EvaluationStreamServerMessage;
import ru.yandex.solomon.alert.protobuf.EvaluationStreamServerMessage.Evaluation;
import ru.yandex.solomon.alert.protobuf.EvaluationStreamServerMessage.EvaluationError;

/**
 * @author Vladimir Gordiychuk
 */
public class EvaluationStreamServerMessageWriter extends BatchWriter<EvaluationStreamServerMessage> {
    private final EvaluationStreamServerMessage.Builder builder = EvaluationStreamServerMessage.newBuilder();

    public EvaluationStreamServerMessageWriter(StreamObserver<EvaluationStreamServerMessage> output, int maxBatchSize) {
        super(output, maxBatchSize);
    }

    public EvaluationStreamServerMessageWriter(StreamObserver<EvaluationStreamServerMessage> output) {
        super(output, MAX_BATCH_SIZE_IN_BYTES);
    }

    public void onNextEvaluations(List<Evaluation> evaluations) {
        for (var evaluation : evaluations) {
            onNext(evaluation);
        }
    }

    public void onNext(EvaluationError error) {
        builder.addErrors(error);
        add(error.getSerializedSize());
    }

    public void onNext(Evaluation evaluation) {
        builder.addEvaluations(evaluation);
        add(evaluation.getSerializedSize());
    }

    @Override
    protected EvaluationStreamServerMessage build() {
        try {
            return builder.build();
        } finally {
            builder.clear();
        }
    }
}
