package ru.yandex.solomon.alert.cluster.server.grpc.evaluation;

import java.util.concurrent.Flow;
import java.util.concurrent.Flow.Subscription;
import java.util.function.Function;

import static java.util.Objects.requireNonNull;

/**
 * @author Vladimir Gordiychuk
 */
public class MapSubscriber<Input, Output> implements Flow.Subscriber<Input> {
    private final Flow.Subscriber<Output> actual;
    private final Function<Input, Output> fn;
    private Subscription subscription;

    public MapSubscriber(Flow.Subscriber<Output> actual, Function<Input, Output> fn) {
        this.actual = actual;
        this.fn = fn;
    }

    @Override
    public void onSubscribe(Subscription subscription) {
        requireNonNull(subscription, "Subscription cannot be null");
        if (this.subscription != null) {
            subscription.cancel();
            return;
        }

        this.subscription = subscription;
        this.actual.onSubscribe(subscription);
    }

    @Override
    public void onNext(Input item) {
        actual.onNext(fn.apply(item));
    }

    @Override
    public void onError(Throwable throwable) {
        actual.onError(throwable);
    }

    @Override
    public void onComplete() {
        actual.onComplete();
    }
}
