package ru.yandex.solomon.alert.cluster.server.grpc.evaluation;

import ru.yandex.solomon.alert.protobuf.EvaluationServerStatusResponse;

/**
 * @author Vladimir Gordiychuk
 */
public record NodeEvaluationStatus(
        String node,
        double cpuNanos,
        double evaluationRate,
        int assignments,
        long receivedAt)
{
    public static final NodeEvaluationStatus EMPTY = new NodeEvaluationStatus("", 0,0,0,0);

    public static NodeEvaluationStatus of(String node, EvaluationServerStatusResponse response) {
        return new NodeEvaluationStatus(
                node,
                response.getCpuNanos(),
                response.getEvaluationRate(),
                response.getAssignmentsCount(),
                System.currentTimeMillis()
        );
    }
}
