package ru.yandex.solomon.alert.cost;

import java.time.Instant;
import java.util.concurrent.CompletableFuture;

import javax.annotation.Nonnull;

import ru.yandex.solomon.alert.domain.Alert;

/**
 * @author Vladimir Gordiychuk
 */
public interface AlertCostEstimator {
    /**
     * @param now time period on that need check cost of alert
     * @param alert alert to calculate cost
     */
    @Nonnull
    CompletableFuture<Double> estimateCost(Instant now, Alert alert, Instant deadline);
}
