package ru.yandex.solomon.alert.dao;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

import ru.yandex.solomon.alert.protobuf.TPersistAlertState;
import ru.yandex.solomon.balancer.AssignmentSeqNo;

/**
 * @author Vladimir Gordiychuk
 */
public interface AlertStatesDao extends SchemaAwareDao {
    /**
     * @return create or alerter schema if it's necessary before start work with alerts
     */
    CompletableFuture<?> createSchema(String projectId);

    CompletableFuture<?> save(String projectId, Instant time, AssignmentSeqNo seqNo, List<TPersistAlertState> states);

    CompletableFuture<Void> find(String projectId, Consumer<TPersistAlertState> consumer);

    default CompletableFuture<List<TPersistAlertState>> findAll(String projectId) {
        List<TPersistAlertState> result = new ArrayList<>();
        return find(projectId, result::add).thenApply(ignore -> result);
    }

    CompletableFuture<?> deleteProject(String projectId);
}
