package ru.yandex.solomon.alert.dao;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;

import ru.yandex.solomon.alert.template.domain.AlertTemplate;
import ru.yandex.solomon.alert.template.domain.AlertTemplateLastVersion;
import ru.yandex.solomon.core.db.SchemaAwareDao;
import ru.yandex.solomon.ydb.page.TokenBasePage;

/**
 * @author Alexey Trushkin
 */
public interface AlertTemplateDao extends SchemaAwareDao {

    CompletableFuture<Boolean> create(AlertTemplate alertTemplate);

    CompletableFuture<Optional<AlertTemplate>> findById(String id, String templateVersionTag);

    CompletableFuture<List<AlertTemplate>> getAll();

    CompletableFuture<List<AlertTemplate>> findVersions(List<AlertTemplateLastVersion> items);

    CompletableFuture<Boolean> publish(AlertTemplate newAlertTemplate, int version);

    CompletableFuture<TokenBasePage<AlertTemplate>> listTemplateVersions(String templateId, int pageSize, String pageToken);

    CompletableFuture<TokenBasePage<AlertTemplate>> listLastTemplates(
            String serviceProviderId,
            String nameFilter,
            String labelsSelector,
            int pageSize,
            String pageToken,
            Predicate<AlertTemplate> skip);
}
