package ru.yandex.solomon.alert.dao;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.alert.template.domain.AlertTemplateLastVersion;
import ru.yandex.solomon.core.db.SchemaAwareDao;
import ru.yandex.solomon.ydb.page.TokenBasePage;

/**
 * @author Alexey Trushkin
 */
public interface AlertTemplateLastVersionDao extends SchemaAwareDao {

    CompletableFuture<TokenBasePage<AlertTemplateLastVersion>> find(String serviceProviderId, String name, int pageSize, String pageToken);

    CompletableFuture<Optional<AlertTemplateLastVersion>> findById(String id);

    CompletableFuture<Boolean> delete(String id, int version);

    CompletableFuture<Boolean> create(AlertTemplateLastVersion alertTemplateLastVersion);

    CompletableFuture<Boolean> updateDeployTask(String templateId, int version, String taskId);

    CompletableFuture<List<AlertTemplateLastVersion>> getAll();
}
