package ru.yandex.solomon.alert.dao;

import ru.yandex.solomon.alert.domain.Alert;
import ru.yandex.solomon.alert.mute.domain.Mute;
import ru.yandex.solomon.alert.notification.domain.Notification;

/**
 * @author Vladimir Gordiychuk
 */
public class DaoFactoryImpl implements DaoFactory {
    private final EntitiesDao<Alert> alertsDao;
    private final EntitiesDao<Notification> notificationsDao;
    private final AlertStatesDao statesDao;
    private EntitiesDao<Mute> mutesDao;

    public DaoFactoryImpl(
            EntitiesDao<Alert> alertsDao,
            EntitiesDao<Notification> notificationsDao,
            EntitiesDao<Mute> mutesDao,
            AlertStatesDao statesDao)
    {
        this.alertsDao = alertsDao;
        this.notificationsDao = notificationsDao;
        this.mutesDao = mutesDao;
        this.statesDao = statesDao;
    }

    @Override
    public EntitiesDao<Alert> alertsDao(String projectId) {
        return alertsDao;
    }

    @Override
    public EntitiesDao<Notification> notificationsDao(String projectId) {
        return notificationsDao;
    }

    @Override
    public EntitiesDao<Mute> mutesDao(String projectId) {
        return mutesDao;
    }

    @Override
    public AlertStatesDao alertStatesDao(String projectId) {
        return statesDao;
    }
}
