package ru.yandex.solomon.alert.dao;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.alert.domain.Alert;
import ru.yandex.solomon.idempotency.IdempotentOperation;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class DelegateAlertsDao implements AlertsDao {
    private final EntitiesDao<Alert> delegate;

    private DelegateAlertsDao(EntitiesDao<Alert> delegate) {
        this.delegate = delegate;
    }

    public static AlertsDao wrap(EntitiesDao<Alert> delegate) {
        return new DelegateAlertsDao(delegate);
    }

    @Override
    public CompletableFuture<?> createSchemaForTests() {
        return delegate.createSchemaForTests();
    }

    @Override
    public CompletableFuture<?> createSchema(String projectId) {
        return delegate.createSchema(projectId);
    }

    @Override
    public CompletableFuture<Optional<Alert>> insert(Alert entity, IdempotentOperation op) {
        return delegate.insert(entity, op);
    }

    @Override
    public CompletableFuture<Optional<Alert>> update(Alert entity, IdempotentOperation op) {
        return delegate.update(entity, op);
    }

    @Override
    public CompletableFuture<Void> deleteById(String projectId, String id, IdempotentOperation op) {
        return delegate.deleteById(projectId, id, op);
    }

    @Override
    public CompletableFuture<Void> deleteProject(String projectId) {
        return delegate.deleteProject(projectId);
    }

    @Override
    public CompletableFuture<Void> find(String projectId, Consumer<Alert> consumer) {
        return delegate.find(projectId, consumer);
    }

    @Override
    public CompletableFuture<Set<String>> findProjects() {
        return delegate.findProjects();
    }

    @Override
    public CompletableFuture<List<Alert>> findAll(String projectId) {
        return delegate.findAll(projectId);
    }
}
