package ru.yandex.solomon.alert.dao;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.alert.domain.AlertSeverity;
import ru.yandex.solomon.alert.notification.domain.Notification;
import ru.yandex.solomon.idempotency.IdempotentOperation;


/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class DelegateNotificationsDao implements NotificationsDao {
    private final EntitiesDao<Notification> delegate;

    private DelegateNotificationsDao(EntitiesDao<Notification> delegate) {
        this.delegate = delegate;
    }

    public static NotificationsDao wrap(EntitiesDao<Notification> delegate) {
        return new DelegateNotificationsDao(delegate);
    }

    @Override
    public CompletableFuture<?> createSchemaForTests() {
        return delegate.createSchemaForTests();
    }

    @Override
    public CompletableFuture<?> createSchema(String projectId) {
        return delegate.createSchema(projectId);
    }

    @Override
    public CompletableFuture<Optional<Notification>> insert(Notification entity, IdempotentOperation op) {
        return delegate.insert(entity, op);
    }

    @Override
    public CompletableFuture<Optional<Notification>> update(Notification entity, IdempotentOperation op) {
        return delegate.update(entity, op);
    }

    @Override
    public CompletableFuture<Void> deleteById(String projectId, String id, IdempotentOperation op) {
        return delegate.deleteById(projectId, id, op);
    }

    @Override
    public CompletableFuture<Void> deleteProject(String projectId) {
        return delegate.deleteProject(projectId);
    }

    @Override
    public CompletableFuture<Void> find(String projectId, Consumer<Notification> consumer) {
        return delegate.find(projectId, consumer);
    }

    @Override
    public CompletableFuture<Set<String>> findProjects() {
        return delegate.findProjects();
    }

    @Override
    public CompletableFuture<List<Notification>> findAll(String projectId) {
        return delegate.findAll(projectId);
    }

    @Override
    public CompletableFuture<Void> deleteByIdWithValidations(String projectId, String id, IdempotentOperation op, Set<AlertSeverity> validateSeverities) {
        return delegate.deleteById(projectId, id, op);
    }

    @Override
    public CompletableFuture<Optional<Notification>> updateWithValidations(Notification entity, IdempotentOperation op, Set<AlertSeverity> validateSeverities) {
        return delegate.update(entity, op);
    }
}
