package ru.yandex.solomon.alert.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

import ru.yandex.solomon.idempotency.IdempotentOperation;

/**
 * @author Vladimir Gordiychuk
 */
public interface EntitiesDao<T> extends SchemaAwareDao {
    /**
     * @return create or schema if it's necessary before start work with entities
     */
    CompletableFuture<?> createSchemaForTests();

    CompletableFuture<?> createSchema(String projectId);

    // Returns Optional.of(oldValue) on insert conflict, Optional.empty() if was successful
    CompletableFuture<Optional<T>> insert(T entity, IdempotentOperation op);

    // Returns Optional.of(oldValue) or Optional.empty() if no value existed by key
    CompletableFuture<Optional<T>> update(T entity, IdempotentOperation op);

    CompletableFuture<Void> deleteById(String projectId, String id, IdempotentOperation op);

    CompletableFuture<Void> deleteProject(String projectId);

    CompletableFuture<Void> find(String projectId, Consumer<T> consumer);

    CompletableFuture<Set<String>> findProjects();

    default CompletableFuture<List<T>> findAll(String projectId) {
        ArrayList<T> result = new ArrayList<>();
        return find(projectId, result::add).thenApply(ignore -> result);
    }
}
