package ru.yandex.solomon.alert.dao;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.alert.domain.AlertSeverity;
import ru.yandex.solomon.alert.notification.domain.Notification;
import ru.yandex.solomon.idempotency.IdempotentOperation;

/**
 * @author Vladimir Gordiychuk
 */
public interface NotificationsDao extends EntitiesDao<Notification> {

    CompletableFuture<Void> deleteByIdWithValidations(String projectId, String id, IdempotentOperation op, Set<AlertSeverity> validateSeverities);

    CompletableFuture<Optional<Notification>> updateWithValidations(Notification entity, IdempotentOperation op, Set<AlertSeverity> validateSeverities);
}
