package ru.yandex.solomon.alert.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

import javax.annotation.Nullable;

import ru.yandex.solomon.alert.rule.EvaluationState;

/**
 * @author Vladimir Gordiychuk
 */
public interface ProjectEvaluationLogsDao extends SchemaAwareDao {
    CompletableFuture<Void> save(EvaluationState state);

    CompletableFuture<Void> save(List<EvaluationState> states);

    CompletableFuture<Void> delete(FilterOpts filter);

    CompletableFuture<Optional<EvaluationState>> findOne(long tsMilli, String parentId, String alertId);

    CompletableFuture<Void> findMany(FilterOpts filter, Consumer<EvaluationState> consumer);

    default CompletableFuture<List<EvaluationState>> findMany(FilterOpts filter) {
        List<EvaluationState> result = new ArrayList<>();
        return findMany(filter, result::add).thenApply(ignore -> result);
    }

    class FilterOpts {
        public long fromMillis;
        public long toMillis;
        @Nullable
        public String parentId;
        @Nullable
        public String alertId;
        public int limit;

        public FilterOpts setFromMillis(long fromMillis) {
            this.fromMillis = fromMillis - 1;
            return this;
        }

        public FilterOpts setToMillis(long toMillis) {
            this.toMillis = toMillis;
            return this;
        }

        public FilterOpts setParentId(@Nullable String parentId) {
            this.parentId = parentId;
            return this;
        }

        public FilterOpts setAlertId(@Nullable String alertId) {
            this.alertId = alertId;
            return this;
        }

        public FilterOpts setLimit(int limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public String toString() {
            return "FilterOpts{" +
                "fromMillis=" + fromMillis +
                ", toMillis=" + toMillis +
                ", parentId='" + parentId + '\'' +
                ", alertId='" + alertId + '\'' +
                ", limit=" + limit +
                '}';
        }
    }
}
