package ru.yandex.solomon.alert.dao;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

/**
 * @author Vladimir Gordiychuk
 */
public interface ProjectsHolder {
    CompletableFuture<Void> reload();
    CompletableFuture<Boolean> hasProject(String projectId);

    /**
     * @return empty if not initialized yet
     */
    Set<String> getProjects();

    Optional<ProjectHolderImpl.ProjectView> getProjectView(String id);
}
