package ru.yandex.solomon.alert.dao;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;


/**
 * @author alexlovkov
 **/
public interface TelegramDao extends SchemaAwareDao {

    CompletableFuture<Void> migrate();

    CompletableFuture<Void> upsert(TelegramRecord record);

    CompletableFuture<Optional<TelegramRecord>> get(long chatId);

    CompletableFuture<Void> deleteById(long chatId);

    CompletableFuture<List<TelegramRecord>> findAll();
}
