package ru.yandex.solomon.alert.dao;

import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.annotations.VisibleForTesting;

/**
 * Place to hold various choices made by user via bot buttons
 * @author Ivan Tsybulin
 */
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_DEFAULT)
public class TelegramEventContext {
    public long muteToMillis;

    public String labelsSelectors;

    @VisibleForTesting
    public void copyFrom(TelegramEventContext context) {
        muteToMillis = context == null ? 0 : context.muteToMillis;
        labelsSelectors = context == null ? null : context.labelsSelectors;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        TelegramEventContext that = (TelegramEventContext) o;

        if (muteToMillis != that.muteToMillis) {
            return false;
        }
        return labelsSelectors != null ? labelsSelectors.equals(that.labelsSelectors) : that.labelsSelectors == null;
    }

    @Override
    public int hashCode() {
        int result = (int) (muteToMillis ^ (muteToMillis >>> 32));
        result = 31 * result + (labelsSelectors != null ? labelsSelectors.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "TelegramEventContext{" +
                "muteToMillis=" + muteToMillis +
                ", labelsSelectors='" + labelsSelectors + '\'' +
                '}';
    }
}
