package ru.yandex.solomon.alert.dao;

import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;


/**
 * @author alexlovkov
 **/
public interface TelegramEventsDao extends SchemaAwareDao {

    CompletableFuture<Void> insert(TelegramEventRecord record);

    CompletableFuture<Optional<TelegramEventRecord>> find(String id);

    /**
     * remove all rows from dao which are older than instant
     */
    CompletableFuture<Void> deleteOlderThan(Instant instant);

    CompletableFuture<Void> updateContext(TelegramEventRecord record);
}
