package ru.yandex.solomon.alert.dao;

/**
 * @author alexlovkov
 **/
public class TelegramRecord {
    private final long chatId;

    /**
     * telegram login if it's user or title of the group chat
     */
    private final String name;

    /**
     * true if it's group chat, false otherwise
     */
    private final boolean group;

    public static TelegramRecord createForUser(long chatId, String telegramLogin) {
        return new TelegramRecord(chatId, telegramLogin, false);
    }

    public static TelegramRecord createForChat(long chatId, String chatTitle) {
        return new TelegramRecord(chatId, chatTitle, true);
    }

    public TelegramRecord(long chatId, String name, boolean group) {
        this.chatId = chatId;
        this.name = name;
        this.group = group;
    }

    public long getChatId() {
        return chatId;
    }

    public String getName() {
        return name;
    }

    public boolean isGroup() {
        return group;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        TelegramRecord that = (TelegramRecord) o;

        if (chatId != that.chatId) return false;
        if (group != that.group) return false;
        return name != null ? name.equals(that.name) : that.name == null;
    }

    @Override
    public int hashCode() {
        int result = (int) (chatId ^ (chatId >>> 32));
        result = 31 * result + (name != null ? name.hashCode() : 0);
        result = 31 * result + (group ? 1 : 0);
        return result;
    }

    @Override
    public String toString() {
        return "TelegramRecord{" +
            "chatId=" + chatId +
            ", name='" + name + '\'' +
            ", group=" + group +
            '}';
    }
}
