package ru.yandex.solomon.alert.dao.migrate;

import java.time.Instant;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

import com.google.common.base.Throwables;

import ru.yandex.solomon.alert.dao.AlertStatesDao;
import ru.yandex.solomon.alert.dao.ydb.YdbExceptionHandler;
import ru.yandex.solomon.alert.protobuf.TPersistAlertState;
import ru.yandex.solomon.balancer.AssignmentSeqNo;

/**
 * @author Vladimir Gordiychuk
 */
public class MigrateProjectAlertStateDao implements AlertStatesDao {
    private final AlertStatesDao source;
    private final AlertStatesDao target;

    public MigrateProjectAlertStateDao(AlertStatesDao source, AlertStatesDao target) {
        this.source = source;
        this.target = target;
    }

    @Override
    public CompletableFuture<?> createSchemaForTests() {
        return target.createSchemaForTests();
    }

    @Override
    public CompletableFuture<?> createSchema(String projectId) {
        return target.createSchema(projectId);
    }

    @Override
    public CompletableFuture<?> save(String projectId, Instant time, AssignmentSeqNo seqNo, List<TPersistAlertState> states) {
        return source.save(projectId, time, seqNo, states)
                .exceptionally((e) -> {
                    if (YdbExceptionHandler.isPathDoesNotExist(e)) {
                        return null;
                    } else {
                        throw Throwables.propagate(e);
                    }
                })
                .thenCompose(ignore -> target.save(projectId, time, seqNo, states));
    }

    @Override
    public CompletableFuture<Void> find(String projectId, Consumer<TPersistAlertState> consumer) {
        return source.find(projectId, consumer).exceptionally(e -> {
            if (YdbExceptionHandler.isPathDoesNotExist(e)) {
                target.find(projectId, consumer);
            } else {
                throw new RuntimeException(e);
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<?> deleteProject(String projectId) {
        return source.deleteProject(projectId)
            .thenCompose(ignore -> target.deleteProject(projectId));
    }
}
