package ru.yandex.solomon.alert.dao.ydb;

import com.yandex.ydb.table.SchemeClient;
import com.yandex.ydb.table.TableClient;

import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.alert.dao.AlertStatesDao;
import ru.yandex.solomon.alert.dao.migrate.MigrateProjectAlertStateDao;
import ru.yandex.solomon.alert.dao.ydb.entity.YdbAlertsStatesDao;

/**
 * @author Vladimir Gordiychuk
 */
public class YdbAlertStatesDaoFactory {

    public static AlertStatesDao create(String root, TableClient table, SchemeClient schema, YdbSchemaVersion version, MetricRegistry registry) {
        if (version == YdbSchemaVersion.MIN) {
            return createByVersion(root, table, schema, version, registry);
        } else {
            AlertStatesDao prev = createByVersion(root, table, schema, YdbSchemaVersion.MIN, registry);
            AlertStatesDao target = createByVersion(root, table, schema, version, registry);
            return new MigrateProjectAlertStateDao(prev, target);
        }
    }

    private static AlertStatesDao createByVersion(String root, TableClient table, SchemeClient schema, YdbSchemaVersion version, MetricRegistry registry) {
        return new YdbAlertsStatesDao(root, table, schema, version, registry);
    }
}
