package ru.yandex.solomon.alert.dao.ydb;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yandex.ydb.table.SchemeClient;
import com.yandex.ydb.table.TableClient;

import ru.yandex.solomon.alert.dao.AlertsDao;
import ru.yandex.solomon.alert.dao.DelegateAlertsDao;
import ru.yandex.solomon.alert.dao.migrate.MigrateEntityDao;
import ru.yandex.solomon.alert.dao.ydb.entity.YdbAlertsDao;

/**
 * @author Vladimir Gordiychuk
 */
public class YdbAlertsDaoFactory {

    public static AlertsDao create(String root, TableClient tableClient, SchemeClient schemeClient, YdbSchemaVersion version, ObjectMapper mapper) {
        if (version == YdbSchemaVersion.MIN) {
            return createByVersion(root, tableClient, schemeClient, version, mapper);
        } else {
            var prev = createByVersion(root, tableClient, schemeClient, YdbSchemaVersion.MIN, mapper);
            var target = createByVersion(root, tableClient, schemeClient, version, mapper);
            return DelegateAlertsDao.wrap(new MigrateEntityDao<>(prev, target));
        }
    }

    private static AlertsDao createByVersion(String root, TableClient tableClient, SchemeClient schemeClient, YdbSchemaVersion version, ObjectMapper mapper) {
        return new YdbAlertsDao(root, tableClient, schemeClient, version, mapper);
    }
}
