package ru.yandex.solomon.alert.dao.ydb;

import com.yandex.ydb.core.StatusCode;
import com.yandex.ydb.core.UnexpectedResultException;

/**
 * @author Vladimir Gordiychuk
 */
public class YdbExceptionHandler {

    public static boolean isPathDoesNotExist(Throwable t) {
        Throwable cause = t;
        while (cause != null) {
            if (cause instanceof UnexpectedResultException) {
                UnexpectedResultException ydbError = (UnexpectedResultException) cause;
                return ydbError.getStatusCode() == StatusCode.SCHEME_ERROR;
            }
            cause = cause.getCause();
        }
        return false;
    }
}
