package ru.yandex.solomon.alert.dao.ydb;

import java.time.Clock;

import com.yandex.ydb.table.SchemeClient;
import com.yandex.ydb.table.TableClient;

import ru.yandex.solomon.alert.dao.SchemaAwareLocksDao;
import ru.yandex.solomon.alert.dao.migrate.MigrateLocksDao;
import ru.yandex.solomon.alert.dao.ydb.entity.YdbVersionedLocksDao;

/**
 * @author Vladimir Gordiychuk
 */
public final class YdbLocksDaoFactory {

    private YdbLocksDaoFactory() {
    }

    public static SchemaAwareLocksDao create(String root, TableClient tableClient, SchemeClient schemeClient, YdbSchemaVersion version, Clock clock) {
        if (version == YdbSchemaVersion.MIN) {
            return ydbLocksDaoByVersion(root, tableClient, schemeClient, version, clock);
        } else {
            var prev = ydbLocksDaoByVersion(root, tableClient, schemeClient, YdbSchemaVersion.MIN, clock);
            var target = ydbLocksDaoByVersion(root, tableClient, schemeClient, version, clock);
            return new MigrateLocksDao(prev, target);
        }
    }

    private static SchemaAwareLocksDao ydbLocksDaoByVersion(String root, TableClient table, SchemeClient schema, YdbSchemaVersion version, Clock clock) {
        return new YdbVersionedLocksDao(root, table, schema, version, clock);
    }
}
