package ru.yandex.solomon.alert.dao.ydb;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yandex.ydb.table.SchemeClient;
import com.yandex.ydb.table.TableClient;

import ru.yandex.solomon.alert.dao.DelegateMutesDao;
import ru.yandex.solomon.alert.dao.MutesDao;
import ru.yandex.solomon.alert.dao.migrate.MigrateEntityDao;
import ru.yandex.solomon.alert.dao.ydb.entity.YdbMutesDao;

/**
 * @author Ivan Tsybulin
 */
public class YdbMutesDaoFactory {

    public static MutesDao create(String root, TableClient tableClient, SchemeClient schemeClient, YdbSchemaVersion version, ObjectMapper mapper) {
        if (version == YdbSchemaVersion.MIN) {
            return createByVersion(root, tableClient, schemeClient, version, mapper);
        } else {
            var prev = createByVersion(root, tableClient, schemeClient, YdbSchemaVersion.MIN, mapper);
            var target = createByVersion(root, tableClient, schemeClient, version, mapper);
            return DelegateMutesDao.wrap(new MigrateEntityDao<>(prev, target));
        }
    }

    private static MutesDao createByVersion(String root, TableClient tableClient, SchemeClient schemeClient, YdbSchemaVersion version, ObjectMapper mapper) {
        return new YdbMutesDao(root, tableClient, schemeClient, version, mapper);
    }
}
