package ru.yandex.solomon.alert.dao.ydb;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yandex.ydb.table.SchemeClient;
import com.yandex.ydb.table.TableClient;

import ru.yandex.solomon.alert.dao.DelegateNotificationsDao;
import ru.yandex.solomon.alert.dao.NotificationsDao;
import ru.yandex.solomon.alert.dao.migrate.MigrateEntityDao;
import ru.yandex.solomon.alert.dao.ydb.entity.YdbNotificationsDao;

/**
 * @author Vladimir Gordiychuk
 */
public class YdbNotificationsDaoFactory {

    public static NotificationsDao create(String root, TableClient tableClient, SchemeClient schemeClient, YdbSchemaVersion version, ObjectMapper mapper) {
        if (version == YdbSchemaVersion.MIN) {
            return createByVersion(root, tableClient, schemeClient, version, mapper);
        } else {
            var prev = createByVersion(root, tableClient, schemeClient, YdbSchemaVersion.MIN, mapper);
            var target = createByVersion(root, tableClient, schemeClient, version, mapper);
            return DelegateNotificationsDao.wrap(new MigrateEntityDao<>(prev, target));
        }
    }

    private static NotificationsDao createByVersion(String root, TableClient tableClient, SchemeClient schemeClient, YdbSchemaVersion version, ObjectMapper mapper) {
        return new YdbNotificationsDao(root, tableClient, schemeClient, version, mapper);
    }
}
