package ru.yandex.solomon.alert.dao.ydb;

import javax.annotation.Nullable;

import ru.yandex.misc.lang.StringUtils;
import ru.yandex.solomon.codec.UnsupportedFormatRuntimeException;

/**
 * @author Vladimir Gordiychuk
 */
public enum YdbSchemaVersion {
    ALERT_DESCRIPTION_6(6),
    ;

    public static final YdbSchemaVersion CURRENT = ALERT_DESCRIPTION_6;
    private static final YdbSchemaVersion[] VALUES = values();
    public static final YdbSchemaVersion MAX = VALUES[0];
    public static final YdbSchemaVersion MIN = VALUES[VALUES.length - 1];
    private final int num;
    private final String folderName;

    YdbSchemaVersion(int num) {
        this.num = num;
        this.folderName = YdbSchemaVersion.folderName(num);
    }

    public int getNumber() {
        return num;
    }

    @Nullable
    public YdbSchemaVersion previous() {
        int nextIndex = ordinal() + 1;
        if (nextIndex >= VALUES.length) {
            return null;
        }

        return VALUES[nextIndex];
    }

    public String folderName() {
        return folderName;
    }

    public boolean gt(YdbSchemaVersion that) {
        return this.num > that.num;
    }

    public boolean ge(YdbSchemaVersion that) {
        return this.num >= that.num;
    }

    public static YdbSchemaVersion forNumber(int number) {
        for (YdbSchemaVersion version : VALUES) {
            if (version.getNumber() == number) {
                return version;
            }
        }

        throw new UnsupportedFormatRuntimeException("unknown format: " + number);
    }

    public static int numberByFolderName(String folderName) {
        if (folderName.charAt(0) != 'V') {
            return -1;
        }

        String num = folderName.substring(1);
        if (!StringUtils.isNumericArabic(num)) {
            return -1;
        }

        return Integer.parseInt(num);
    }

    public static String folderName(int num) {
        return "V" + num;
    }

}
