package ru.yandex.solomon.alert.dao.ydb;

import com.yandex.ydb.table.SchemeClient;
import com.yandex.ydb.table.TableClient;

import ru.yandex.solomon.alert.dao.TelegramDao;
import ru.yandex.solomon.alert.dao.migrate.MigrateTelegramDao;
import ru.yandex.solomon.alert.dao.ydb.entity.YdbTelegramDao;


/**
 * @author alexlovkov
 **/
public class YdbTelegramDaoFactory {

    public static TelegramDao create(String root, TableClient table, SchemeClient scheme, YdbSchemaVersion version) {
        if (version == YdbSchemaVersion.MIN) {
            return createByVersion(root, table, scheme, version);
        } else {
            var prev = createByVersion(root, table, scheme, YdbSchemaVersion.MIN);
            var target = createByVersion(root, table, scheme, version);
            return new MigrateTelegramDao(prev, target);
        }
    }

    private static TelegramDao createByVersion(String root, TableClient table, SchemeClient scheme, YdbSchemaVersion version) {
        return new YdbTelegramDao(root, table, scheme, version);
    }

}
