package ru.yandex.solomon.alert.dao.ydb.entity;

import java.util.concurrent.CompletableFuture;

import com.google.protobuf.ByteString;

import ru.yandex.solomon.alert.dao.SchemaAwareDao;

/**
 * @author Vladimir Gordiychuk
 */
public interface AlertStatesChunksDao extends SchemaAwareDao {

    CompletableFuture<?> deleteProject(String projectId);

    CompletableFuture<Integer> uploadChunks(String projectId, String fileId, ByteString bytes);

    CompletableFuture<ByteString> downloadChunks(String projectId, String fileId, int countChunks);

    CompletableFuture<?> deleteFileChunks(String projectId, String fileId);

    int getChunkSize();
}
