package ru.yandex.solomon.alert.dao.ydb.entity;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

import ru.yandex.solomon.alert.dao.SchemaAwareDao;
import ru.yandex.solomon.alert.protobuf.TPersistAlertState;

/**
 * @author Vladimir Gordiychuk
 */
public interface AlertStatesFilesDao extends SchemaAwareDao {

    CompletableFuture<?> upload(String projectId, String fileId, long createdAt, List<TPersistAlertState> states);

    CompletableFuture<Void> download(String projectId, String fileId, Consumer<TPersistAlertState> consumer);

    CompletableFuture<?> deleteFile(String projectId, String fileId);

    CompletableFuture<?> deleteProject(String projectId);
}
