package ru.yandex.solomon.alert.dao.ydb.entity;

import java.time.Clock;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import com.yandex.ydb.table.SchemeClient;
import com.yandex.ydb.table.TableClient;

import ru.yandex.solomon.alert.dao.SchemaAwareLocksDao;
import ru.yandex.solomon.alert.dao.ydb.YdbSchemaVersion;
import ru.yandex.solomon.locks.LockDetail;
import ru.yandex.solomon.locks.dao.ydb.YdbLocksDao;

/**
 * @author Vladimir Gordiychuk
 */
public class YdbVersionedLocksDao implements SchemaAwareLocksDao {
    private final String path;
    private final SchemeClient scheme;
    private final YdbLocksDao dao;

    public YdbVersionedLocksDao(String root, TableClient tableClient, SchemeClient schemeClient, YdbSchemaVersion version, Clock clock) {
        this.path = root + "/Alerting/" + version.folderName();
        this.scheme = schemeClient;
        this.dao = new YdbLocksDao(tableClient, clock, path);
    }

    @Override
    public CompletableFuture<?> createSchemaForTests() {
        return scheme.makeDirectories(path)
            .thenCompose(ignore -> dao.createSchema());
    }

    @Override
    public CompletableFuture<LockDetail> acquireLock(String lockId, String owner, Instant expiredAt) {
        return dao.acquireLock(lockId, owner, expiredAt);
    }

    @Override
    public CompletableFuture<Optional<LockDetail>> readLock(String lockId) {
        return dao.readLock(lockId);
    }

    @Override
    public CompletableFuture<Boolean> extendLockTime(String lockId, String owner, Instant expiredAt) {
        return dao.extendLockTime(lockId, owner, expiredAt);
    }

    @Override
    public CompletableFuture<Boolean> releaseLock(String lockId, String owner) {
        return dao.releaseLock(lockId, owner);
    }

    @Override
    public CompletableFuture<List<LockDetail>> listLocks() {
        return dao.listLocks();
    }
}
