package ru.yandex.solomon.alert.dao.ydb.queries;

/**
 * @author Alexey Trushkin
 */
public class AlertTemplateLastVersionQueries {

    public static final String FIND_VERSIONS_TEMPLATE = """
            --!syntax_v1
            DECLARE $serviceProviderId AS Utf8;
            DECLARE $name AS Utf8;
            DECLARE $pageSize AS Int32;
            DECLARE $pageOffset AS Int32;

            $textGrep = Re2::Grep($name);

            SELECT * FROM `%s`
            WHERE (LENGTH($serviceProviderId) = 0 OR serviceProviderId = $serviceProviderId) AND
             (LENGTH($name) = 0 OR $textGrep(name))
            LIMIT $pageSize OFFSET $pageOffset;
            """;

    public static final String FIND_ONE_TEMPLATE = """
            --!syntax_v1
            DECLARE $id AS Utf8;

            SELECT * FROM `%s`
            WHERE id = $id;
            """;

    public static final String INSERT_TEMPLATE = """
            --!syntax_v1
            DECLARE $id AS Utf8;
            DECLARE $templateVersionTag AS Utf8;
            DECLARE $serviceProviderId AS Utf8;
            DECLARE $name AS Utf8;
            DECLARE $version AS Uint32;
            DECLARE $publishingTaskId AS Utf8;

            INSERT INTO `%s` (id,templateVersionTag,serviceProviderId,name,version,publishingTaskId)
            VALUES ($id,$templateVersionTag,$serviceProviderId,$name,$version,$publishingTaskId);
            """;

    public static final String UPDATE_TASK_TEMPLATE = """
            --!syntax_v1
            DECLARE $id AS Utf8;
            DECLARE $version AS Uint32;
            DECLARE $publishingTaskId AS Utf8;

            $update = (
              SELECT
                id,
                templateVersionTag,
                serviceProviderId,
                name,
                CAST($version + 1 AS Uint32) AS version,
                $publishingTaskId as publishingTaskId
              FROM `%s`
              WHERE id = $id AND version = $version
            );

            SELECT TRUE as value FROM $update;

            UPSERT INTO `%s`
            SELECT * FROM $update;
            """;

    public static final String DELETE_TEMPLATE = """
            --!syntax_v1
            DECLARE $id AS Utf8;
            DECLARE $version AS Uint32;

            SELECT TRUE AS value
            FROM `%s`
            WHERE id = $id AND version = $version;

            DELETE FROM `%s`
            WHERE id = $id AND version = $version;
            """;
}
