package ru.yandex.solomon.alert.dao.ydb.queries;

/**
 * @author Alexey Trushkin
 */
public class AlertTemplateQueries {

    public static final String INSERT_TEMPLATE = """
            --!syntax_v1
            DECLARE $id AS Utf8;
            DECLARE $templateVersionTag AS Utf8;
            DECLARE $alertTemplateType AS Utf8;
            DECLARE $serviceProviderId AS Utf8;
            DECLARE $name AS Utf8;
            DECLARE $description AS Utf8;
            DECLARE $data AS Json;
            DECLARE $createdAt AS Int64;
            DECLARE $updatedAt AS Int64;
            DECLARE $createdBy AS Utf8;
            DECLARE $updatedBy AS Utf8;

            INSERT INTO `%s` (id,templateVersionTag,alertTemplateType,serviceProviderId,name,description,data,createdAt,updatedAt,createdBy,updatedBy)
            VALUES ($id,$templateVersionTag,$alertTemplateType,$serviceProviderId,$name,$description,$data,$createdAt,$updatedAt,$createdBy,$updatedBy);
            """;


    public static final String FIND_TEMPLATE = """
            --!syntax_v1
            DECLARE $id AS Utf8;
            DECLARE $templateVersionTag AS Utf8;

            SELECT * FROM `%s`
            WHERE id = $id AND templateVersionTag = $templateVersionTag;
            """;

    public static final String FIND_LIST_TEMPLATE = """
            --!syntax_v1
            DECLARE $rows AS %s;

            SELECT * FROM `%s` as a INNER JOIN AS_TABLE($rows) as b ON (a.id = b.id AND a.templateVersionTag = b.templateVersionTag);
            """;

    public static final String INSERT_PUBLISHED_TEMPLATE = """
            --!syntax_v1
            DECLARE $id AS Utf8;
            DECLARE $templateVersionTag AS Utf8;
            DECLARE $alertTemplateType AS Utf8;
            DECLARE $serviceProviderId AS Utf8;
            DECLARE $name AS Utf8;
            DECLARE $description AS Utf8;
            DECLARE $data AS Json;
            DECLARE $createdAt AS Int64;
            DECLARE $updatedAt AS Int64;
            DECLARE $createdBy AS Utf8;
            DECLARE $updatedBy AS Utf8;
            DECLARE $publishingTaskId AS Utf8;

            INSERT INTO `%s/AlertTemplateLastVersions` (id,templateVersionTag,serviceProviderId,name,version, publishingTaskId)
            VALUES ($id,$templateVersionTag,$serviceProviderId,$name,0,$publishingTaskId);

            UPSERT INTO `%s/AlertTemplates` (id,templateVersionTag,alertTemplateType,serviceProviderId,name,description,data,createdAt,updatedAt,createdBy,updatedBy)
            VALUES ($id,$templateVersionTag,$alertTemplateType,$serviceProviderId,$name,$description,$data,$createdAt,$updatedAt,$createdBy,$updatedBy);
            """;

    public static final String INSERT_PUBLISHED_WITH_UPDATE_TEMPLATE = """
            --!syntax_v1
            DECLARE $id AS Utf8;
            DECLARE $templateVersionTag AS Utf8;
            DECLARE $alertTemplateType AS Utf8;
            DECLARE $serviceProviderId AS Utf8;
            DECLARE $name AS Utf8;
            DECLARE $description AS Utf8;
            DECLARE $data AS Json;
            DECLARE $createdAt AS Int64;
            DECLARE $updatedAt AS Int64;
            DECLARE $createdBy AS Utf8;
            DECLARE $updatedBy AS Utf8;
            DECLARE $version AS Uint32;
            DECLARE $publishingTaskId AS Utf8;

            $update = (
              SELECT
                id,
                $templateVersionTag AS templateVersionTag,
                serviceProviderId,
                $name as name,
                CAST($version + 1 AS Uint32) AS version,
                $publishingTaskId as publishingTaskId
              FROM `%s/AlertTemplateLastVersions`
              WHERE id = $id AND version = $version
            );

            SELECT TRUE as value FROM $update;

            UPSERT INTO `%s/AlertTemplateLastVersions`
            SELECT * FROM $update;

            UPSERT INTO `%s/AlertTemplates`
            SELECT id,templateVersionTag,$alertTemplateType as alertTemplateType,serviceProviderId,name,$description as description,$data as data,$createdAt as createdAt,$updatedAt as updatedAt,$createdBy as createdBy,$updatedBy as updatedBy FROM $update;
            """;

    public static final String FIND_TEMPLATE_VERSIONS_TEMPLATE = """
            --!syntax_v1
            DECLARE $id AS Utf8;
            DECLARE $pageSize AS Int32;
            DECLARE $pageOffset AS Int32;

            SELECT * FROM `%s`
            WHERE id = $id
            ORDER BY createdAt
            LIMIT $pageSize OFFSET $pageOffset;
            """;

    public static final String FIND_TEMPLATES_TEMPLATE = """
            --!syntax_v1
            DECLARE $serviceProviderId AS Utf8;
            DECLARE $name AS Utf8;

            $textGrep = Re2::Grep($name);

            SELECT CAST(COUNT(id) AS Uint64) AS cnt
            FROM `%s/AlertTemplates`
             WHERE ($serviceProviderId = '' or serviceProviderId = $serviceProviderId) AND
              (LENGTH($name) = 0 OR $textGrep(name));

            SELECT *
            FROM `%s/AlertTemplates`
            WHERE ($serviceProviderId = '' or serviceProviderId = $serviceProviderId) AND
              (LENGTH($name) = 0 OR $textGrep(name))
            ORDER BY createdAt DESC
            LIMIT ${page.size} OFFSET ${page.offset};
            """;
}
