package ru.yandex.solomon.alert.domain;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Nonnegative;

import ru.yandex.solomon.alert.dao.Entity;

/**
 * @author Vladimir Gordiychuk
 */
public interface Alert extends Entity {
    AlertKey getKey();

    String getName();

    String getDescription();

    AlertState getState();

    @Override
    int getVersion();

    Map<String, ChannelConfig> getNotificationChannels();

    Set<String> getEscalations();

    List<String> getGroupByLabels();

    AlertType getAlertType();

    Map<String, String> getAnnotations();

    Map<String, String> getServiceProviderAnnotations();

    Map<String, String> getLabels();

    @Nonnegative
    Duration getPeriod();

    /**
     * Time (in seconds) to delay evaluation relatively now.
     * Useful for delayed metrics like cluster aggregation. Should be a non negative integer.
     */
    @Nonnegative
    int getDelaySeconds();

    ResolvedEmptyPolicy getResolvedEmptyPolicy();

    NoPointsPolicy getNoPointsPolicy();

    AlertSeverity getSeverity();

    int getMetricsLimit();

    /**
     * Compare alerts content ignoring modify attributes(updatedAt, updatedBy, version, etc)
     */
    boolean equalContent(Alert alert);

    AbstractAlertBuilder<?, ?> toBuilder();

    boolean isObtainedFromTemplate();
}
