package ru.yandex.solomon.alert.domain;

import javax.annotation.Nonnull;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;

/**
 * @author Vladimir Gordiychuk
 */
public final class AlertInterner {
    public static final Interner<Alert> I = Interners.newWeakInterner();
    public static final Interner<Alert> NOOP = new Interner<>() {
        @Nonnull
        @Override
        public Alert intern(@Nonnull Alert value) {
            return value;
        }
    };

    private AlertInterner() {

    }
}
