package ru.yandex.solomon.alert.domain;

import java.util.Objects;

import javax.annotation.ParametersAreNullableByDefault;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNullableByDefault
public final class AlertKey implements Comparable<AlertKey> {
    private final String projectId;
    /**
     * Empty for regular alert, and filled for sub alerts
     */
    private final String parentId;
    private final String alertId;

    public AlertKey(String projectId, String parentId, String alertId) {
        this.projectId = Objects.requireNonNull(projectId);
        this.parentId = parentId;
        this.alertId = Objects.requireNonNull(alertId);
    }

    public String getProjectId() {
        return projectId;
    }

    public String getAlertId() {
        return alertId;
    }

    public String getParentId() {
        return parentId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AlertKey key = (AlertKey) o;

        if (!projectId.equals(key.projectId)) return false;
        if (!parentId.equals(key.parentId)) return false;
        return alertId.equals(key.alertId);
    }

    @Override
    public int hashCode() {
        int result = projectId.hashCode();
        result = 31 * result + parentId.hashCode();
        result = 31 * result + alertId.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this.getClass().getSimpleName())
                .omitNullValues()
                .add("projectId", projectId)
                .add("parentId", Strings.emptyToNull(parentId))
                .add("alertId", alertId)
                .toString();
    }

    @Override
    public int compareTo(AlertKey o) {
        int compare = projectId.compareTo(o.projectId);
        if (compare != 0) {
            return compare;
        }
        compare = parentId.compareTo(o.parentId);
        if (compare != 0) {
            return compare;
        }
        return alertId.compareTo(o.alertId);
    }
}
