package ru.yandex.solomon.alert.domain;

import ru.yandex.solomon.alert.protobuf.Severity;

/**
 * @author Alexey Trushkin
 */
public enum AlertSeverity {
    UNKNOWN(Severity.SEVERITY_UNSPECIFIED.getNumber()),
    DISASTER(Severity.SEVERITY_DISASTER.getNumber()),
    CRITICAL(Severity.SEVERITY_CRITICAL.getNumber()),
    INFO(Severity.SEVERITY_INFO.getNumber()),
    ;

    private final int number;

    AlertSeverity(int number) {
        this.number = number;
    }

    public int getNumber() {
        return number;
    }

    public static AlertSeverity forNumber(int number) {
        for (AlertSeverity policy : values()) {
            if (policy.getNumber() == number) {
                return policy;
            }
        }

        throw new IllegalArgumentException("Not found severity with number: " + number);
    }
}
