package ru.yandex.solomon.alert.domain;

/**
 * @author Vladimir Gordiychuk
 */
public enum AlertState {
    ACTIVE(0),
    DELETED(1),
    MUTED(2);

    private final int number;

    AlertState(int number) {
        this.number = number;
    }

    public static final AlertState[] VALUES = values();

    public static AlertState forNumber(int num) {
        for (AlertState type : VALUES) {
            if (type.getNumber() == num) {
                return type;
            }
        }

        throw new IllegalArgumentException("Not found type with number: " + num);
    }

    public int getNumber() {
        return number;
    }
}
