package ru.yandex.solomon.alert.domain;

/**
 * @author Vladimir Gordiychuk
 */
public enum AlertType {
    /**
     * Threshold are useful for a continuous stream of data. Metrics can be alerted upon
     * if they cross a threshold over a given period of time.
     */
    THRESHOLD(0),

    /**
     * Expression are useful when other alerts type not applicable. And allow fully customisable
     * check via solomon-expression.
     */
    EXPRESSION(1),

    // TODO: implement it
    /**
     * Outlier detect when a member of a group (e.g., hosts, availability zones, partitions)
     * is behaving unusually compared to the rest. They are useful for any metric where a given
     * group should behave uniformly.
     */
    OUTLIER(2),

    // TODO: implement it
    /**
     * Anomaly detect when a metric is behaving differently than it has in the past,
     * taking into account trends, seasonal day-of-week and time-of-day patterns.
     */
    ANOMALY(3),

    /**
     * Children alert of one of {@link AlertType} for check particular label group.
     */
    SUB_ALERT(4),

    /**
     * Templated alert, would be one of {@link AlertType}.
     */
    FROM_TEMPLATE(5);

    private final int number;

    AlertType(int number) {
        this.number = number;
    }

    public static AlertType forNumber(int num) {
        for (AlertType type : values()) {
            if (type.getNumber() == num) {
                return type;
            }
        }

        throw new IllegalArgumentException("Not found type with number: " + num);
    }

    public int getNumber() {
        return number;
    }
}
