package ru.yandex.solomon.alert.domain;

import java.time.Duration;
import java.util.Objects;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.alert.EvaluationStatus;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class ChannelConfig {
    public static final ChannelConfig EMPTY = new ChannelConfig(Set.of(), Duration.ZERO);

    private final Set<EvaluationStatus.Code> notifyAboutStatuses;
    private final Duration repeatNotificationDelay;

    public ChannelConfig(Set<EvaluationStatus.Code> notifyAboutStatuses, Duration repeatNotificationDelay) {
        this.notifyAboutStatuses = notifyAboutStatuses;
        this.repeatNotificationDelay = repeatNotificationDelay;
    }

    public Set<EvaluationStatus.Code> getNotifyAboutStatusesUnchecked() {
        return notifyAboutStatuses;
    }

    public Duration getRepeatNotificationDelayUnchecked() {
        return repeatNotificationDelay;
    }

    public Set<EvaluationStatus.Code> getNotifyAboutStatusesOrDefault(Set<EvaluationStatus.Code> defaultNotifyAboutStatuses) {
        if (this == EMPTY) {
            return defaultNotifyAboutStatuses;
        }
        return notifyAboutStatuses;
    }

    public Duration getRepeatNotificationDelayOrDefault(Duration defaultRepeatNotificationDelay) {
        if (this == EMPTY) {
            return defaultRepeatNotificationDelay;
        }
        return repeatNotificationDelay;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ChannelConfig config = (ChannelConfig) o;
        return notifyAboutStatuses.equals(config.notifyAboutStatuses) &&
            repeatNotificationDelay.equals(config.repeatNotificationDelay);
    }

    @Override
    public int hashCode() {
        return Objects.hash(notifyAboutStatuses, repeatNotificationDelay);
    }

    @Override
    public String toString() {
        return "ChannelConfig{" +
            "notifyAboutStatuses=" + notifyAboutStatuses +
            ", repeatNotificationDelay=" + repeatNotificationDelay +
            '}';
    }
}
